/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.explorer.internal.ui;

import com.aptana.core.IScopeReference;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.resources.IProjectContext;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.explorer.ExplorerPlugin;
import com.aptana.explorer.internal.ui.AppExplorerActionGroup;
import com.aptana.explorer.internal.ui.CaseInsensitiveProjectComparator;
import com.aptana.explorer.internal.ui.Messages;
import com.aptana.ui.util.UIUtils;
import com.aptana.ui.widgets.SearchComposite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.NewWizardAction;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ImportExportWizard;
import org.eclipse.ui.internal.navigator.wizards.WizardShortcutAction;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.swt.IFocusService;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SingleProjectView
extends CommonNavigator
implements SearchComposite.Client,
IProjectContext {
    private static final String RAILS_NATURE = "org.radrails.rails.core.railsnature";
    private static final String WEB_NATURE = "com.aptana.projects.webnature";
    private static final String PHP_NATURE = "com.aptana.editor.php.phpNature";
    private static final Set<String> TO_REMOVE = new HashSet<String>();
    private ToolItem projectToolItem;
    private Menu projectsMenu;
    protected IProject selectedProject;
    private ResourceListener fProjectsListener;
    private Composite filterComp;
    private CLabel filterLabel;
    private GridData filterLayoutData;
    private IEclipsePreferences.IPreferenceChangeListener fActiveProjectPrefChangeListener;
    private Label noProjectslabel;
    private Composite noProjectButtonsComp;
    private Label closedProjectlabel;
    private Composite closedProjectButtonsComp;
    private PageBook pageBook;
    private Button createProjectWhenNoneButton;
    private Button importProjectWhenNoneButton;
    private Button openProjectButton;
    private Button createProjectWhenClosedButton;
    private Button importProjectWhenClosedButton;
    private static final String CLOSE_ICON = "icons/full/elcl16/close.png";

    static {
        TO_REMOVE.add("compareWithMenu");
        TO_REMOVE.add("replaceWithMenu");
        TO_REMOVE.add("org.eclipse.ui.framelist.goInto");
        TO_REMOVE.add("org.radrails.rails.ui.actions.RunScriptServerAction");
        TO_REMOVE.add("org.radrails.rails.ui.actions.DebugScriptServerAction");
    }

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = (GridLayout)parent.getLayout();
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 1;
        Composite toolbarComposite = new Composite(parent, 0);
        toolbarComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        GridLayout toolbarGridLayout = new GridLayout(2, false);
        toolbarGridLayout.marginWidth = 0;
        toolbarGridLayout.marginHeight = 0;
        toolbarGridLayout.horizontalSpacing = 0;
        toolbarComposite.setLayout((Layout)toolbarGridLayout);
        Composite pulldowns = new Composite(toolbarComposite, 0);
        pulldowns.setLayoutData((Object)new GridData(4, 1, true, false));
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = true;
        rowLayout.spacing = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginBottom = 0;
        rowLayout.marginTop = 0;
        pulldowns.setLayout((Layout)rowLayout);
        this.createProjectCombo(pulldowns);
        this.doCreateToolbar(pulldowns);
        this.createSearchComposite(parent);
        this.filterComp = this.createFilterComposite(parent);
        this.createNavigator(parent);
        this.getViewSite().getActionBars().getToolBarManager().remove("org.eclipse.ui.framelist.back");
        this.getViewSite().getActionBars().getToolBarManager().remove("org.eclipse.ui.framelist.forward");
        this.getViewSite().getActionBars().getToolBarManager().remove("org.eclipse.ui.framelist.up");
        this.addProjectResourceListener();
        this.setActiveProject(this.detectSelectedProject());
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IScopeReference.class) {
            return new IScopeReference(){

                public String getScopeId() {
                    if (SingleProjectView.this.selectedProject != null) {
                        block7: {
                            block6: {
                                if (!SingleProjectView.this.selectedProject.hasNature(SingleProjectView.RAILS_NATURE)) break block6;
                                return "project.rails";
                            }
                            if (!SingleProjectView.this.selectedProject.hasNature(SingleProjectView.WEB_NATURE)) break block7;
                            return "project.web";
                        }
                        try {
                            if (SingleProjectView.this.selectedProject.hasNature(SingleProjectView.PHP_NATURE)) {
                                return "project.php";
                            }
                        }
                        catch (CoreException e) {
                            ExplorerPlugin.logError(e);
                        }
                    }
                    return null;
                }
            };
        }
        if (adapter == IProject.class) {
            return this.selectedProject;
        }
        return super.getAdapter(adapter);
    }

    public void saveState(IMemento aMemento) {
        if (aMemento != null && this.selectedProject != null) {
            aMemento.putString("activeProject", this.selectedProject.getName());
        }
        super.saveState(aMemento);
    }

    protected abstract void doCreateToolbar(Composite var1);

    private IProject[] createProjectCombo(Composite parent) {
        final ToolBar projectsToolbar = new ToolBar(parent, 0x800000);
        this.projectToolItem = new ToolItem(projectsToolbar, 4);
        Object[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        List sortedProjects = CollectionsUtil.newList((Object[])projects);
        Collections.sort(sortedProjects, new CaseInsensitiveProjectComparator());
        this.projectsMenu = new Menu((Control)projectsToolbar);
        for (IProject iProject : sortedProjects) {
            if (!iProject.exists()) continue;
            final MenuItem projectNameMenuItem = new MenuItem(this.projectsMenu, 16);
            projectNameMenuItem.setText(iProject.getName());
            projectNameMenuItem.setSelection(false);
            Image image = null;
            image = iProject.isOpen() ? PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT") : PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT_CLOSED");
            if (image != null) {
                projectNameMenuItem.setImage(image);
            }
            projectNameMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String projectName = projectNameMenuItem.getText();
                    SingleProjectView.this.projectToolItem.setText(projectName);
                    SingleProjectView.this.setActiveProject(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
                }
            });
        }
        this.projectToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Point toolbarLocation = projectsToolbar.getLocation();
                toolbarLocation = projectsToolbar.getParent().toDisplay(toolbarLocation.x, toolbarLocation.y);
                Point toolbarSize = projectsToolbar.getSize();
                SingleProjectView.this.projectsMenu.setLocation(toolbarLocation.x, toolbarLocation.y + toolbarSize.y + 2);
                SingleProjectView.this.projectsMenu.setVisible(true);
            }
        });
        return projects;
    }

    protected Composite createSearchComposite(Composite myComposite) {
        SearchComposite search = new SearchComposite(myComposite, (SearchComposite.Client)this);
        search.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        IFocusService focusService = (IFocusService)this.getViewSite().getService(IFocusService.class);
        focusService.addFocusTracker((Control)search.getTextControl(), "com.aptana.explorer.view.searchText");
        return search;
    }

    private void createNavigator(Composite myComposite) {
        Composite viewer = new Composite(myComposite, 2048);
        viewer.setLayout((Layout)new FillLayout());
        viewer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.pageBook = new PageBook(viewer, 0);
        super.createPartControl((Composite)this.pageBook);
        IProject selectedProject = this.detectSelectedProject();
        this.getCommonViewer().setInput((Object)selectedProject);
        this.createNoProjectsComposite();
        this.createClosedProjectComposite();
        if (selectedProject != null) {
            if (selectedProject.isAccessible()) {
                this.pageBook.showPage(this.getCommonViewer().getControl());
            } else {
                this.pageBook.showPage((Control)this.closedProjectButtonsComp);
            }
        } else {
            this.pageBook.showPage((Control)this.noProjectButtonsComp);
        }
        this.fixNavigatorManager();
    }

    protected Composite createNoProjectsComposite() {
        this.noProjectButtonsComp = new Composite((Composite)this.pageBook, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.noProjectButtonsComp);
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000000).applyTo((Control)this.noProjectButtonsComp);
        this.noProjectslabel = new Label(this.noProjectButtonsComp, 64);
        this.noProjectslabel.setText(Messages.SingleProjectView_NoProjectsDescription);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).indent(5, 10).applyTo((Control)this.noProjectslabel);
        this.createProjectWhenNoneButton = new Button(this.noProjectButtonsComp, 0x800000);
        this.createProjectWhenNoneButton.setText(Messages.SingleProjectView_CreateProjectButtonLabel);
        this.createProjectWhenNoneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewWizardAction action = new NewWizardAction(UIUtils.getActiveWorkbenchWindow());
                action.run();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).indent(0, 5).applyTo((Control)this.createProjectWhenNoneButton);
        this.importProjectWhenNoneButton = new Button(this.noProjectButtonsComp, 0x800000);
        this.importProjectWhenNoneButton.setText(Messages.SingleProjectView_ImportProjectButtonLabel);
        this.importProjectWhenNoneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SingleProjectView.this.openImportWizard();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)this.importProjectWhenNoneButton);
        return this.noProjectButtonsComp;
    }

    protected Composite createClosedProjectComposite() {
        this.closedProjectButtonsComp = new Composite((Composite)this.pageBook, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.closedProjectButtonsComp);
        GridDataFactory.fillDefaults().grab(true, true).align(0x1000000, 0x1000000).applyTo((Control)this.closedProjectButtonsComp);
        this.closedProjectlabel = new Label(this.closedProjectButtonsComp, 64);
        this.closedProjectlabel.setText(Messages.SingleProjectView_ClosedProjectSelectedLabel);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).indent(5, 10).applyTo((Control)this.closedProjectlabel);
        this.openProjectButton = new Button(this.closedProjectButtonsComp, 0x800000);
        this.openProjectButton.setText(Messages.SingleProjectView_OpenProjectButton);
        this.openProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    SingleProjectView.this.selectedProject.open((IProgressMonitor)new NullProgressMonitor());
                    SingleProjectView.this.pageBook.showPage(SingleProjectView.this.getCommonViewer().getControl());
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).indent(0, 5).applyTo((Control)this.openProjectButton);
        this.createProjectWhenClosedButton = new Button(this.closedProjectButtonsComp, 0x800000);
        this.createProjectWhenClosedButton.setText(Messages.SingleProjectView_CreateProjectButtonLabel);
        this.createProjectWhenClosedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewWizardAction action = new NewWizardAction(UIUtils.getActiveWorkbenchWindow());
                action.run();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)this.createProjectWhenClosedButton);
        this.importProjectWhenClosedButton = new Button(this.closedProjectButtonsComp, 0x800000);
        this.importProjectWhenClosedButton.setText(Messages.SingleProjectView_ImportProjectButtonLabel);
        this.importProjectWhenClosedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SingleProjectView.this.openImportWizard();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)this.importProjectWhenClosedButton);
        return this.closedProjectButtonsComp;
    }

    protected CommonViewer createCommonViewer(Composite aParent) {
        CommonViewer aViewer = this.createCommonViewerObject(aParent);
        this.initListeners((TreeViewer)aViewer);
        aViewer.getNavigatorContentService().restoreState(this.memento);
        return aViewer;
    }

    protected CommonViewer createCommonViewerObject(Composite aParent) {
        return new CommonViewer(this.getViewSite().getId(), aParent, 66306){

            public ISelection getSelection() {
                ISelection sel = super.getSelection();
                if (sel.isEmpty() && SingleProjectView.this.selectedProject != null) {
                    ArrayList<IProject> selectedProjectList = new ArrayList<IProject>();
                    selectedProjectList.add(SingleProjectView.this.selectedProject);
                    TreePath treePath = new TreePath(selectedProjectList.toArray());
                    TreeSelection treeSelection = new TreeSelection(treePath);
                    return treeSelection;
                }
                return sel;
            }
        };
    }

    protected ActionGroup createCommonActionGroup() {
        return new AppExplorerActionGroup(this, this.getCommonViewer(), this.getLinkHelperService());
    }

    private void fixNavigatorManager() {
        UIJob job = new UIJob(this.getTitle()){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                SingleProjectView.this.getCommonViewer().setSelection(SingleProjectView.this.getCommonViewer().getSelection());
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.setPriority(40);
        job.schedule(250L);
        this.getCommonViewer().getTree().getMenu().addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                Menu menu = (Menu)e.getSource();
                SingleProjectView.this.mangleContextMenu(menu);
            }

            public void menuHidden(MenuEvent e) {
            }
        });
    }

    private Composite createFilterComposite(Composite myComposite) {
        Composite filter = new Composite(myComposite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 2;
        filter.setLayout((Layout)gridLayout);
        this.filterLayoutData = new GridData(4, 0x1000000, true, false);
        this.filterLayoutData.exclude = true;
        filter.setLayoutData((Object)this.filterLayoutData);
        this.filterLabel = new CLabel(filter, 16384);
        this.filterLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBar toolBar = new ToolBar(filter, 0x800000);
        toolBar.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ToolItem toolItem = new ToolItem(toolBar, 8);
        toolItem.setImage(ExplorerPlugin.getImage(CLOSE_ICON));
        toolItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SingleProjectView.this.removeFilter();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return filter;
    }

    private void hideFilterLabel() {
        this.filterLayoutData.exclude = true;
        this.filterComp.setVisible(false);
        this.filterComp.getParent().layout();
    }

    protected void showFilterLabel(Image image, String text) {
        this.filterLabel.setImage(image);
        this.filterLabel.setText(text);
        this.filterLayoutData.exclude = false;
        this.filterComp.setVisible(true);
        this.filterComp.getParent().layout();
    }

    protected void removeFilter() {
        this.hideFilterLabel();
    }

    private void addProjectResourceListener() {
        this.fProjectsListener = new ResourceListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fProjectsListener, 1);
    }

    private IProject detectSelectedProject() {
        IProject project = null;
        String activeProjectName = null;
        if (this.memento != null) {
            activeProjectName = this.memento.getString("activeProject");
        }
        if (activeProjectName != null) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(activeProjectName);
        }
        if (project == null) {
            String value = Platform.getPreferencesService().getString("com.aptana.explorer", "activeProject", null, null);
            if (value != null) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(value);
            }
            if (project == null) {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                if (projects == null || projects.length == 0) {
                    return null;
                }
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject proj = iProjectArray[n2];
                    if (proj.isAccessible()) {
                        project = proj;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return project;
    }

    public void setActiveProject(IProject newSelectedProject) {
        boolean projectIsSame = this.selectedProject != null && newSelectedProject != null && this.selectedProject.equals((Object)newSelectedProject);
        IProject oldActiveProject = this.selectedProject;
        this.selectedProject = newSelectedProject;
        if (newSelectedProject != null) {
            if (!projectIsSame) {
                this.setActiveProject();
            }
            if (newSelectedProject.isAccessible()) {
                this.pageBook.showPage(this.getCommonViewer().getControl());
            } else if (newSelectedProject.exists()) {
                this.pageBook.showPage((Control)this.closedProjectButtonsComp);
            }
        } else {
            this.unsetActiveProject();
            this.pageBook.showPage((Control)this.noProjectButtonsComp);
        }
        if (!projectIsSame) {
            this.projectChanged(oldActiveProject, newSelectedProject);
        }
    }

    private void setActiveProject() {
        try {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.explorer");
            prefs.put("activeProject", this.selectedProject.getName());
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ExplorerPlugin.getDefault(), (Throwable)e);
        }
    }

    private void unsetActiveProject() {
        try {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.explorer");
            prefs.remove("activeProject");
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ExplorerPlugin.getDefault(), (Throwable)e);
        }
    }

    protected void projectChanged(IProject oldProject, IProject newProject) {
        MenuItem[] menuItems;
        String newProjectName = "";
        if (newProject != null && newProject.exists()) {
            newProjectName = newProject.getName();
        }
        this.projectToolItem.setText(newProjectName);
        MenuItem[] menuItemArray = menuItems = this.projectsMenu.getItems();
        int n = menuItems.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = menuItemArray[n2];
            menuItem.setSelection(menuItem.getText().equals(newProjectName));
            ++n2;
        }
        this.getCommonViewer().setInput((Object)newProject);
        if (newProject == null) {
            this.getCommonViewer().setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    protected void refreshViewer() {
        if (this.getCommonViewer() == null || this.getCommonViewer().getTree() == null || this.getCommonViewer().getTree().isDisposed()) {
            return;
        }
        this.getCommonViewer().refresh((Object)this.selectedProject, true);
    }

    public void dispose() {
        super.dispose();
        this.removeProjectResourceListener();
        this.removeActiveProjectPrefListener();
    }

    private void removeProjectResourceListener() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fProjectsListener);
        this.fProjectsListener = null;
    }

    private void removeActiveProjectPrefListener() {
        if (this.fActiveProjectPrefChangeListener != null) {
            InstanceScope.INSTANCE.getNode("com.aptana.explorer").removePreferenceChangeListener(this.fActiveProjectPrefChangeListener);
        }
        this.fActiveProjectPrefChangeListener = null;
    }

    public void search(String text, boolean isCaseSensitive, boolean isRegularExpression) {
        if (this.selectedProject == null) {
            return;
        }
        IProject searchResource = this.selectedProject;
        TextSearchPageInput input = new TextSearchPageInput(text, isCaseSensitive, isRegularExpression, FileTextSearchScope.newSearchScope((IResource[])new IResource[]{searchResource}, (String[])new String[]{"*"}, (boolean)false));
        try {
            NewSearchUI.runQueryInBackground((ISearchQuery)TextSearchQueryProvider.getPreferred().createQuery((TextSearchQueryProvider.TextSearchInput)input));
        }
        catch (CoreException e) {
            ExplorerPlugin.logError(e);
        }
    }

    protected void mangleContextMenu(Menu menu) {
        if (this.selectedProject != null && this.selectedProject.isAccessible()) {
            this.forceOurNewFileWizard(menu);
        }
        this.removeMenuItems(menu, TO_REMOVE);
        boolean lastWasSeparator = false;
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = menuItemArray[n2];
            Object data = menuItem.getData();
            if (data instanceof Separator) {
                if (lastWasSeparator) {
                    menuItem.dispose();
                } else {
                    lastWasSeparator = true;
                }
            } else {
                lastWasSeparator = false;
            }
            ++n2;
        }
    }

    private void forceOurNewFileWizard(Menu menu) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem contrib;
            MenuItem menuItem = menuItemArray[n2];
            Object data = menuItem.getData();
            if (data instanceof IContributionItem && "common.new.menu".equals((contrib = (IContributionItem)data).getId())) {
                MenuManager manager = (MenuManager)contrib;
                IWizardRegistry registry = PlatformUI.getWorkbench().getNewWizardRegistry();
                IWizardDescriptor desc = registry.findWizard("com.aptana.ui.wizards.new.file");
                manager.insertAfter("new", (IAction)new WizardShortcutAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), desc));
                manager.remove("new");
                break;
            }
            ++n2;
        }
    }

    protected void removeMenuItems(Menu menu, Set<String> idsToRemove) {
        if (idsToRemove == null || idsToRemove.isEmpty()) {
            return;
        }
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem contrib;
            MenuItem menuItem = menuItemArray[n2];
            Object data = menuItem.getData();
            if (data instanceof IContributionItem && idsToRemove.contains((contrib = (IContributionItem)data).getId())) {
                menuItem.dispose();
            }
            ++n2;
        }
    }

    public IProject getActiveProject() {
        return this.selectedProject;
    }

    protected void openImportWizard() {
        ImportExportWizard wizard = new ImportExportWizard("import");
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = workbenchSettings.getSection("ImportExportAction");
        if (wizardSettings == null) {
            wizardSettings = workbenchSettings.addNewSection("ImportExportAction");
        }
        wizard.setDialogSettings(wizardSettings);
        wizard.setForcePreviousAndNextButtons(true);
        WizardDialog dialog = new WizardDialog(UIUtils.getActiveShell(), (IWizard)wizard);
        dialog.open();
    }

    private class ResourceListener
    implements IResourceChangeListener {
        private ResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(final IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource.getType() == 1 || resource.getType() == 2) {
                            return false;
                        }
                        if (resource.getType() == 8) {
                            return true;
                        }
                        if (resource.getType() == 4) {
                            if (delta.getKind() == 1 || delta.getKind() == 4 && (delta.getFlags() & 0x4000) != 0 && resource.isAccessible()) {
                                final String projectName = resource.getName();
                                Display.getDefault().asyncExec(new Runnable(){

                                    public void run() {
                                        int index = SingleProjectView.this.projectsMenu.getItemCount();
                                        MenuItem[] items = SingleProjectView.this.projectsMenu.getItems();
                                        int i = 0;
                                        while (i < items.length) {
                                            String otherName = items[i].getText();
                                            int comparison = otherName.compareTo(projectName);
                                            if (comparison == 0) {
                                                index = -1;
                                                break;
                                            }
                                            if (comparison > 0) {
                                                index = i;
                                                break;
                                            }
                                            ++i;
                                        }
                                        if (index == -1) {
                                            return;
                                        }
                                        final MenuItem projectNameMenuItem = new MenuItem(SingleProjectView.this.projectsMenu, 16, index);
                                        projectNameMenuItem.setText(projectName);
                                        projectNameMenuItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT"));
                                        projectNameMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                            public void widgetSelected(SelectionEvent e) {
                                                String projectName = projectNameMenuItem.getText();
                                                SingleProjectView.this.projectToolItem.setText(projectName);
                                                SingleProjectView.this.setActiveProject(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
                                            }
                                        });
                                        if (delta.getKind() == 1) {
                                            projectNameMenuItem.setSelection(true);
                                            SingleProjectView.this.setActiveProject(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
                                        }
                                        SingleProjectView.this.projectToolItem.getParent().pack(true);
                                    }
                                });
                            } else if (delta.getKind() == 2 || delta.getKind() == 4 && (delta.getFlags() & 0x4000) != 0 && !resource.isAccessible()) {
                                final String projectName = resource.getName();
                                Display.getDefault().asyncExec(new Runnable(){

                                    public void run() {
                                        MenuItem[] menuItems;
                                        MenuItem[] menuItemArray = menuItems = SingleProjectView.this.projectsMenu.getItems();
                                        int n = menuItems.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            MenuItem menuItem = menuItemArray[n2];
                                            if (menuItem.getText().equals(projectName)) {
                                                menuItem.dispose();
                                                break;
                                            }
                                            ++n2;
                                        }
                                        if (((ResourceListener)(this).ResourceListener.this).SingleProjectView.this.selectedProject != null && ((ResourceListener)(this).ResourceListener.this).SingleProjectView.this.selectedProject.getName().equals(projectName)) {
                                            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                                            boolean setProject = false;
                                            IProject[] iProjectArray = projects;
                                            int n3 = projects.length;
                                            int n4 = 0;
                                            while (n4 < n3) {
                                                IProject p = iProjectArray[n4];
                                                if (p != null && p.isAccessible()) {
                                                    SingleProjectView.this.setActiveProject(p);
                                                    setProject = true;
                                                    break;
                                                }
                                                ++n4;
                                            }
                                            if (!setProject) {
                                                iProjectArray = projects;
                                                n3 = projects.length;
                                                n4 = 0;
                                                while (n4 < n3) {
                                                    IProject p = iProjectArray[n4];
                                                    if (p != null && p.exists()) {
                                                        SingleProjectView.this.setActiveProject(p);
                                                        setProject = true;
                                                        break;
                                                    }
                                                    ++n4;
                                                }
                                            }
                                            if (!setProject) {
                                                SingleProjectView.this.setActiveProject(null);
                                            }
                                        }
                                        SingleProjectView.this.projectToolItem.getParent().pack(true);
                                    }
                                });
                            }
                        }
                        return false;
                    }
                });
            }
            catch (CoreException e) {
                ExplorerPlugin.logError(e);
            }
        }
    }

    private static class TextSearchPageInput
    extends TextSearchQueryProvider.TextSearchInput {
        private final String fSearchText;
        private final boolean fIsCaseSensitive;
        private final boolean fIsRegEx;
        private final FileTextSearchScope fScope;

        public TextSearchPageInput(String searchText, boolean isCaseSensitive, boolean isRegEx, FileTextSearchScope scope) {
            this.fSearchText = searchText;
            this.fIsCaseSensitive = isCaseSensitive;
            this.fIsRegEx = isRegEx;
            this.fScope = scope;
        }

        public String getSearchText() {
            return this.fSearchText;
        }

        public boolean isCaseSensitiveSearch() {
            return this.fIsCaseSensitive;
        }

        public boolean isRegExSearch() {
            return this.fIsRegEx;
        }

        public FileTextSearchScope getScope() {
            return this.fScope;
        }
    }
}

